/*******************************************************************************
	
		analysis.do
		10.19.2025
		Main analysis for:
		"The Value of Internal Labor Markets: Evidence from LinkedIn Profiles and U.S. Inventors. "
		Letian (LT) Zhang and Simeng Wang
		
*******************************************************************************/


use "all_inventor_linkedin_match9.dta",replace

**# Code promotion/external hire
{
sort id2 rn year 
duplicates drop
by id2: gen order=_n
by id2: gen total_N=_N

sort id2 order
gen last_employer=""
tostring employer_id2, replace
replace employer_id2="" if employer_id2=="."

by id2: replace last_employer=employer_id2[_n-1] if order!=1 
//employer_id2 in previous year
gen start_year_last=.
gen end_year_last=.
by id2: replace start_year_last=start_year[_n-1] if order!=1 
//start_year of last employment
by id2: replace end_year_last=end_year[_n-1] if order!=1 
//end_year of last employment

by id2: gen transition=1 if order<=total_N & year==start_year & (start_year==end_year_last|(start_year<=end_year_last+3& start_year>=end_year_last+1)) & employer_id2!=last_employer &!missing(employer_id2)&!missing(last_employer) 
//exteral job switch=1 if there is an employer change. These conditions have also to be met: year equals to the start year of the employment and the start year is within three years of last job's end year, and the employer name is not missing. 
by id2: replace transition=0 if employer_id2[_n+1]==employer_id2[_n-1] & order!=1 & order!=total_N
//clean up false positive cases. If the employer before and after this observation are the same, and this isn't the first or last job in the person's record, then this middle job is likely not a true transition.
by id2: replace transition=0 if employer_id2==last_employer[_n-1] & order!=1
//clean up false positive cases. If the current employer equals the previous job's last employer, and this isn't the first or last observation for that individual, then reset transition to 0.
replace transition=0 if missing(transition)

tostring title2_id, replace
gen last_title2_id=title2_id[_n-1] if order!=1


gen change_occupation2=1 if last_employer==employer_id2 & last_title2_id!=title2_id&!missing(title2_id)&!missing(last_title2_id)
//internal job switch=1 if title changes but within the same firm
replace change_occupation2=0 if missing(change_occupation2)
sort id2 order
destring title2_id, replace

gen mark32=1 if change_occupation2==1&adj_seniority_us>=3&!missing(adj_seniority_us)
bysort id2 employer_id2 year: gen mark_employee3=1 if _n==1

bysort employer_id2 year: egen total_inventor_year3=total(mark_employee3)
bysort employer_id2 year: egen promotion4=total(mark32)
replace promotion4=promotion4-1 if mark32==1 
//exclude the focal promotion
gen promotion_rate4=(promotion4)/(total_inventor_year3-1)
replace promotion_rate4=0 if promotion4==0
replace promotion_rate4=1 if promotion_rate4>1 & !missing(promotion_rate4) 
//an individual may be promoted multiple times hence very few obesrvations have a promotion rate above 1.

sort id2 order
gen mark9=1 if transition==1&adj_seniority_us>=3&!missing(adj_seniority_us)
bysort employer_id2 year: egen external_hiring2=total(mark9)
replace external_hiring2=external_hiring2-1 if mark9==1

gen external_hiring_rate4=(external_hiring2)/(total_inventor_year3-1)
replace external_hiring_rate4=0 if external_hiring2==0
replace external_hiring_rate4=1 if external_hiring_rate4>1 & !missing(external_hiring_rate4)


bysort employer_id2 year: egen external_hiring_raw4=total(mark9)
bysort employer_id2 year: egen promotion_raw4=total(mark32)
gen vacancy_ey=promotion_raw4+external_hiring_raw4 
//total number of vacancies in each firm-year
save "/analysis_data/all_inventor_linkedin_match9_analysis.dta"
}
**# Prep
{ 

gen ltotal_wt_three_year_citation=ln(total_wt_three_year_citation+0.01)
gen ltotal_cwt_three_year_citation=ln(total_cwt_three_year_citation+0.01)
gen lpatent_count=ln(patent_count+1)

//logged control variables
gen lno_employee_ey=ln(no_employee_ey)
gen ltenure_ey=ln(tenure_ey)
gen lfirm_capacity=ln(cnum_patent_firm2+1)

//FEs
egen long inventor_title=group(inventor_id title2_id)
egen firm_location=group(employer_id2 wk_state) 
egen inventor_location_employer_title=group(inventor_id wk_state employer_id2 title2_id)
bysort id2 employer_id2 title2_id: egen min_year_job=min(year) 
//first year on the job
gen years_on_the_job=year-min_year_job 
//years on the job
bysort inventor_id2: egen min_year=min(year) 
//career start year
gen work_year=year-min_year 
//number of years in the career , proxy for age. 
}

**# Variables Labelling
{

label var external_hiring_rate4 "Num. Externally Hired Inventors/Num. Inventors"
label var promotion_rate4 "Num. Internally Promoted Inventors/Num. Inventors"
label var lno_employee_ey "Num. Employees (log)"
label var prop_rd "Prop. of R\&D Employees"
label var prop_manager "Prop. of Managers"
label var ltenure_ey "Employee Average Tenure (log)"
label var lfirm_capacity "Firm Innovation Capacity (log)"
label var cnum_patent_firm2 "Firm Innovation Capacity"

keep if year<=2025&year>=2000
bysort inventor_id2: egen total_productivity=total(patent_count)
drop if total_productivity==0 //restrict the sample to those who have are actively patenting 
save "/analysis_data/all_inventor_linkedin_match9_analysis.dta"，replace
}
**# Table 1
{
eststo clear

reghdfe ltotal_wt_three_year_citation promotion_rate4   lno_employee_ey    prop_rd prop_manager lfirm_capacity ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5, a(inventor_title year work_year years_on_the_job) cluster(employer_id2)
est store e1
reghdfe ltotal_wt_three_year_citation promotion_rate4     lno_employee_ey    prop_rd prop_manager lfirm_capacity ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5, a(inventor_title firm_location year work_year years_on_the_job) cluster(employer_id2)
est store e2
reghdfe ltotal_wt_three_year_citation promotion_rate4    lno_employee_ey    prop_rd prop_manager lfirm_capacity ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5, a(inventor_location_employer_title firm_location year work_year years_on_the_job) cluster(employer_id2)
est store e3

reghdfe ltotal_wt_three_year_citation promotion_rate4 external_hiring_rate4  lno_employee_ey  lfirm_capacity  prop_rd prop_manager ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5, a(inventor_title year work_year years_on_the_job) cluster(employer_id2)
est store e4
reghdfe ltotal_wt_three_year_citation promotion_rate4 external_hiring_rate4    lno_employee_ey  lfirm_capacity  prop_rd prop_manager ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5, a(inventor_title firm_location year work_year years_on_the_job) cluster(employer_id2)
est store e5
reghdfe ltotal_wt_three_year_citation promotion_rate4 external_hiring_rate4   lno_employee_ey lfirm_capacity   prop_rd prop_manager  ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5, a(inventor_location_employer_title year work_year years_on_the_job) cluster(employer_id2)
est store e6

estadd local fe " ",replace: e1 e2 e3 e4 e5 e6
estadd local yfe "Yes", replace: e1 e2 e3 e4 e5 e6
estadd local wyfe "Yes", replace: e1 e2 e3 e4 e5 e6
estadd local yjfe "Yes", replace: e1 e2 e3 e4 e5 e6
estadd local iofe "Yes", replace: e1 e2 e4 e5
estadd local iolefe "Yes", replace: e2 e5
estadd local iolefe2 "Yes", replace: e3 e6
estadd local control "Yes", replace: e1 e2 e3 e4 e5 e6

esttab e1 e2 e3 e4 e5 e6 using"/results/main_rep.tex", replace label se r2 wrap width(\hsize)title("\label{tab:main2} Linear Estimation Predicting Innovation using Internal Promotion and External Hiring Rates") mgroups ( "Adjusted Three-Year Forward Citation (log)", pattern(1 0 0 0 0 0) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) nomtitles keep(promotion_rate4 external_hiring_rate4 lno_employee_ey    prop_rd prop_manager ltenure_ey lfirm_capacity) order(promotion_rate4 external_hiring_rate4 lno_employee_ey    prop_rd prop_manager ltenure_ey lfirm_capacity) scalar("fe Fixed Effects:" "yfe Calendar Year" "wyfe Years in the Workforce" "yjfe Years on the Job" "iofe Inventor x Occupation" "iolefe Employer x Location" "iolefe2 Inventor x Occupation x Employer x Location" "control Control Variables" )
}

**# Figure 5  Moderator plots-age group
{
cap drop age_group
gen age_group=0 if work_year>=0&work_year<=8
replace age_group=1 if work_year>8 & work_year<=18
replace age_group=2 if work_year>18 & work_year<=28
replace age_group=3 if work_year>28


reghdfe ltotal_wt_three_year_citation c.promotion_rate4##i.age_group    lno_employee_ey lfirm_capacity   prop_rd prop_manager ltenure_ey if year>=2000 & year<=2025&work_year<=50&work_year>=0&total_inventor_year3>=5, a(inventor_title year work_year years_on_the_job) cluster(employer_id2)
cap drop tp*
gen tp1=_b[promotion_rate4] if _n==1
gen tp1_se=_se[promotion_rate4]
gen tp_year=0 if _n==1
foreach num of numlist 1(1)3 {
		replace tp1=_b[`num'.age_group#promotion_rate4]+_b[promotion_rate4] if _n==`num'+1
		replace tp1_se=sqrt(((_se[`num'.age_group#promotion_rate4])^2)+((_se[promotion_rate4])^2)) if _n==`num'+1
		replace tp_year=`num' if _n==`num'+1
}
gen tp1_se1=tp1+1.645*tp1_se
gen tp1_se2=tp1-1.645*tp1_se

set scheme cblind1
twoway scatter  tp1 tp_year,mcolor(red)|| rcap tp1_se1 tp1_se2 tp_year, lcolor(red) mcolor(red) yline(0) ytitle(Estimated Coefficient Predicting Adj. Three-Year Forward Citation (log),size(small)) xtitle(Age Group,size(med)) xlabel( 0 "22~30" 1 "31~40" 2 "41~50 " 3 ">50", nogrid) ylabel(,nogrid) legend(off)
graph export "/results/figures/ratio_age_iofe.png", as(png) name("Graph") replace


reghdfe ltotal_wt_three_year_citation c.promotion_rate4##i.age_group    lno_employee_ey lfirm_capacity   prop_rd prop_manager ltenure_ey if year>=2000 & year<=2025&work_year<=50&work_year>=0&total_inventor_year3>=5, a(inventor_title firm_location year work_year years_on_the_job) cluster(employer_id2)
cap drop tp*
gen tp1=_b[promotion_rate4] if _n==1
gen tp1_se=_se[promotion_rate4]
gen tp_year=0 if _n==1
foreach num of numlist 1(1)3 {
		replace tp1=_b[`num'.age_group#promotion_rate4]+_b[promotion_rate4] if _n==`num'+1
		replace tp1_se=sqrt(((_se[`num'.age_group#promotion_rate4])^2)+((_se[promotion_rate4])^2)) if _n==`num'+1
		replace tp_year=`num' if _n==`num'+1
}
gen tp1_se1=tp1+1.645*tp1_se
gen tp1_se2=tp1-1.645*tp1_se

set scheme cblind1
twoway scatter  tp1 tp_year,mcolor(red)|| rcap tp1_se1 tp1_se2 tp_year, lcolor(red) mcolor(red) yline(0) ytitle(Estimated Coefficient Predicting Adj. Three-Year Forward Citation (log),size(small)) xtitle(Age Group,size(med)) xlabel( 0 "22~30" 1 "31~40" 2 "41~50 " 3 ">50", nogrid) ylabel(,nogrid) legend(off)
graph export "/results/ratio_age_ileofe.png", as(png) name("Graph") replace
}

**# Appendix
	**# Appendix Section C. Summary Statistics 
{
**# Summary Statistics (using the sample of model1)
keep if year>=2000&year<=2025&sample==1
estpost sum  promotion_rate4 external_hiring_rate4 total_wt_three_year_citation application_count_iy patent_count total_patent_value_real total_cwt_three_year_citation  no_employee_ey cnum_patent_firm2 prop_rd prop_manager tenure_ey 
est store a
esttab a  using "/results/summary_stat.tex", replace  booktabs label nonumbers cells("mean  min max sd")  
estpost corr   promotion_rate4 external_hiring_rate4 total_wt_three_year_citation no_employee_ey cnum_patent_firm2 prop_rd prop_manager tenure_ey,matrix
est store b
esttab b  using "/results/corr_table.tex", replace  booktabs label nonumbers unstack


estpost corr total_wt_three_year_citation application_count_iy patent_count total_patent_value_real total_cwt_three_year_citation ,matrix
est store c
esttab c  using "/results/corr_table2.tex", replace  booktabs label nonumbers unstack
}
	
	
	**# Appendix Section D. Alternative Measures of Internal Hiring Rate
//Table D.1
{
use "all_inventor_linkedin_match9_analysis.dta",replace	
	
	
sort id2 order
by id2: gen up=1 if adj_seniority>adj_seniority[_n-1]&!missing(adj_seniority)&order!=1


gen mark32_ha=1 if change_occupation2==1&adj_seniority_us>=3&!missing(adj_seniority_us)&up==1

bysort employer_id2 year: egen promotion4_ha=total(mark32)
replace promotion4_ha=promotion4_ha-1 if mark32_ha==1
gen promotion_rate4_ha=(promotion4_ha)/(total_inventor_year3-1)
replace promotion_rate4_ha=0 if promotion4_ha==0
replace promotion_rate4_ha=1 if promotion_rate4_ha>1 & !missing(promotion_rate4_ha)


eststo clear

reghdfe ltotal_wt_three_year_citation promotion_rate4_ha   lno_employee_ey    prop_rd prop_manager lfirm_capacity ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5, a(inventor_title year work_year years_on_the_job) cluster(employer_id2)
est store e1
reghdfe ltotal_wt_three_year_citation promotion_rate4_ha     lno_employee_ey    prop_rd prop_manager lfirm_capacity ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5, a(inventor_title firm_location year work_year years_on_the_job) cluster(employer_id2)
est store e2
reghdfe ltotal_wt_three_year_citation promotion_rate4_ha    lno_employee_ey    prop_rd prop_manager lfirm_capacity ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5, a(inventor_location_employer_title firm_location year work_year years_on_the_job) cluster(employer_id2)
est store e3

reghdfe ltotal_wt_three_year_citation promotion_rate4_ha external_hiring_rate4  lno_employee_ey  lfirm_capacity  prop_rd prop_manager ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5, a(inventor_title year work_year years_on_the_job) cluster(employer_id2)
est store e4
reghdfe ltotal_wt_three_year_citation promotion_rate4_ha external_hiring_rate4    lno_employee_ey  lfirm_capacity  prop_rd prop_manager ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5, a(inventor_title firm_location year work_year years_on_the_job) cluster(employer_id2)
est store e5
reghdfe ltotal_wt_three_year_citation promotion_rate4_ha external_hiring_rate4   lno_employee_ey lfirm_capacity   prop_rd prop_manager  ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5, a(inventor_location_employer_title year work_year years_on_the_job) cluster(employer_id2)
est store e6

estadd local fe " ",replace: e1 e2 e3 e4 e5 e6
estadd local yfe "Yes", replace: e1 e2 e3 e4 e5 e6
estadd local wyfe "Yes", replace: e1 e2 e3 e4 e5 e6
estadd local yjfe "Yes", replace: e1 e2 e3 e4 e5 e6
estadd local iofe "Yes", replace: e1 e2 e4 e5
estadd local iolefe "Yes", replace: e2 e5
estadd local iolefe2 "Yes", replace: e3 e6
estadd local control "Yes",replace: e1 e2 e3 e4 e5 e6

esttab e1 e2 e3 e4 e5 e6 using"/results/main_rep_seniority.tex", replace label se r2 wrap width(\hsize)title("\label{tab:seniority} Linear Estimation Predicting Innovation Using Alternative Internal Promotion Criteria") mgroups ( "Adjusted Three-Year Forward Citation (log)", pattern(1 0 0 0 0 0) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) nomtitles keep(promotion_rate4_ha external_hiring_rate4 ) order(promotion_rate4_ha external_hiring_rate4 ) scalar("fe Fixed Effects:" "yfe Calendar Year" "wyfe Years in the Workforce" "yjfe Years on the Job" "iofe Inventor x Title" "iolefe Employer x Location" "iolefe2 Inventor x Title x Employer x Location" "control Control Variables")

}

//Table D.2
{
use "all_inventor_linkedin_match9_analysis.dta",replace

keep employer_id2 year external_hiring_raw promotion_raw total_inventor_year3
duplicates drop


foreach var of varlist external_hiring_raw promotion_raw total_inventor_year3{

	bysort employer_id2 (year): gen `var'_3=sum(`var')
	bysort employer_id2: gen `var'_32=`var'_3-`var'_3[_n-3]
	replace `var'_32=`var'_3 if `var'_32==.
	//tally the total number of promotion and external hires in the past 3 years.
}
keep employer_id2 year *_32
duplicates drop

rename external_ external_hiring_3yr
rename promotion  promotion_3yr
rename total total_inventor_year3_3yr
save "three_year_measure.dta",replace

use "all_inventor_linkedin_match9_analysis.dta",replace

keep employer_id2 year inventor_id mark32 mark9
bysort inventor_id employer_id2 year: egen mark32_haha=total(mark32)
bysort inventor_id employer_id2 year: egen mark9_haha=total(mark9)
keep employer_id2 year inventor_id *haha
duplicates drop

keep if year>=1998 & year<=2025

foreach var of varlist mark32_haha mark9_haha{

	bysort inventor_id employer_id2 (year): gen `var'_3=sum(`var')
	bysort inventor_id employer_id2: gen `var'_32=`var'_3-`var'_3[_n-3]
	replace `var'_32=`var'_3 if `var'_32==.
	//tally the total number of promotion and external hires the focal employee has experienced in the past 3 years

}
keep employer_id2 year inventor_id *_32
duplicates drop
save "three_year_measure2.dta",replace


use "three_year_measure.dta",replace
merge 1:m employer_id2 year using "three_year_measure2.dta"
drop _merge
duplicates drop


merge 1:m employer_id2 year inventor_id using "all_inventor_linkedin_match9_analysis.dta"
drop if _merge==1
drop _merge
replace external_hiring_3yr=external_hiring_3yr-mark9_haha_32 
replace promotion_3yr=promotion_3yr-mark32_haha_32
//three-year rolling window measures (excluding focal employees)
save "all_inventor_linkedin_match9_analysis.dta",replace

gen promotion_rate_3yr=promotion_3yr/total_inventor_year3_3yr
replace promotion_rate_3yr=0 if promotion_rate_3yr<0
replace promotion_rate_3yr=1 if promotion_rate_3yr!=.&promotion_rate_3yr>1
gen external_rate_3yr=external_hiring_3yr/total_inventor_year3_3yr
replace external_rate_3yr=0 if external_rate_3yr<0
replace external_rate_3yr=1 if external_rate_3yr>1&!missing(external_rate_3yr)
eststo clear
reghdfe ltotal_wt_three_year_citation promotion_rate_3yr lno_employee_ey lfirm_capacity  prop_rd prop_manager ltenure_ey if year>=2000&year<=2025& total_inventor_year3_3yr >=5, a(inventor_title year work_year years_on_the_job) cluster(employer_id2)
est store e1
reghdfe ltotal_wt_three_year_citation promotion_rate_3yr lno_employee_ey lfirm_capacity  prop_rd prop_manager ltenure_ey if year>=2000&year<=2025& total_inventor_year3_3yr >=5, a(inventor_title firm_location year work_year years_on_the_job) cluster(employer_id2)
est store e2
reghdfe ltotal_wt_three_year_citation promotion_rate_3yr  lno_employee_ey lfirm_capacity  prop_rd prop_manager ltenure_ey if year>=2000&year<=2025& total_inventor_year3_3yr >=5, a(inventor_location_employer_title year work_year years_on_the_job) cluster(employer_id2)
est store e3
reghdfe ltotal_wt_three_year_citation promotion_rate_3yr external_rate_3yr lno_employee_ey lfirm_capacity  prop_rd prop_manager ltenure_ey if year>=2000&year<=2025& total_inventor_year3_3yr >=5, a(inventor_title year work_year years_on_the_job) cluster(employer_id2)
est store e4
reghdfe ltotal_wt_three_year_citation promotion_rate_3yr external_rate_3yr lno_employee_ey lfirm_capacity  prop_rd prop_manager ltenure_ey if year>=2000&year<=2025& total_inventor_year3_3yr >=5, a(inventor_title firm_location year work_year years_on_the_job) cluster(employer_id2)
est store e5
reghdfe ltotal_wt_three_year_citation promotion_rate_3yr external_rate_3yr  lno_employee_ey lfirm_capacity  prop_rd prop_manager ltenure_ey if year>=2000&year<=2025& total_inventor_year3_3yr >=5, a(inventor_location_employer_title year work_year years_on_the_job) cluster(employer_id2)
est store e6


estadd local fe " ",replace: e1 e2 e3 e4 e5 e6 
estadd local yfe "Yes", replace: e1 e2 e3 e4 e5 e6 
estadd local wyfe "Yes", replace: e1 e2 e3 e4 e5 e6 
estadd local yjfe "Yes", replace: e1 e2 e3 e4 e5 e6 
estadd local iofe "Yes", replace: e2 e5
estadd local iolefe "Yes", replace: e2 e5
estadd local iolefe2 "Yes", replace: e3 e6 
estadd local control "Yes", replace: e1 e2 e3 e4 e5 e6 
esttab e1 e2 e3 e4 e5 e6  using"/results/lag_combined.tex", replace label se r2 wrap width(\hsize)title("\label{tab:lag} Linear Estimation Predicting Innovation using Internal Hiring Rate") mgroups (, pattern(1 0 0 0 0 0) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) nomtitles keep( promotion_rate_3yr external_rate_3yr) order( promotion_rate_3yr external_rate_3yr) scalar("fe Fixed Effects:" "yfe Calendar Year" "wyfe Years in the Workforce" "yjfe Years on the Job" "iofe Inventor x Title" "iolefe Employer x Location" "iolefe2 Inventor x Title x Employer x Location" "control Control Variables")

}
	
	**# Appendix Section E. Alternative DVs
{
gen lapplication_count_iy=ln(application_count_iy+1)
gen ltotal_patent_value_real=ln(total_patent_value_real+1)
gen ltotal_three_year_citation=ln(total_three_year_citation+1)


eststo clear

reghdfe lapplication_count_iy promotion_rate4   lno_employee_ey    prop_rd prop_manager lfirm_capacity ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5, a(inventor_title year work_year years_on_the_job) cluster(employer_id2)
est store e1
reghdfe lapplication_count_iy promotion_rate4    lno_employee_ey    prop_rd prop_manager lfirm_capacity ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5, a(inventor_location_employer_title year work_year years_on_the_job) cluster(employer_id2)
est store e2

reghdfe lpatent_count promotion_rate4   lno_employee_ey  lfirm_capacity  prop_rd prop_manager ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5, a(inventor_title year work_year years_on_the_job) cluster(employer_id2)
est store e3
reghdfe lpatent_count promotion_rate4    lno_employee_ey lfirm_capacity   prop_rd prop_manager  ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5, a(inventor_location_employer_title year work_year years_on_the_job) cluster(employer_id2)
est store e4

reghdfe ltotal_patent_value_real promotion_rate4   lno_employee_ey  lfirm_capacity  prop_rd prop_manager ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5, a(inventor_title year work_year years_on_the_job) cluster(employer_id2)
est store e5
reghdfe ltotal_patent_value_real promotion_rate4    lno_employee_ey lfirm_capacity   prop_rd prop_manager  ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5, a(inventor_location_employer_title  year work_year years_on_the_job) cluster(employer_id2)
est store e6

reghdfe ltotal_three_year_citation promotion_rate4   lno_employee_ey  lfirm_capacity  prop_rd prop_manager ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5, a(inventor_title year work_year years_on_the_job) cluster(employer_id2)
est store e7
reghdfe ltotal_three_year_citation promotion_rate4    lno_employee_ey lfirm_capacity   prop_rd prop_manager  ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5, a(inventor_location_employer_title year work_year years_on_the_job) cluster(employer_id2)
est store e8

reghdfe ltotal_cwt_three_year_citation promotion_rate4   lno_employee_ey  lfirm_capacity  prop_rd prop_manager ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5, a(inventor_title year work_year years_on_the_job) cluster(employer_id2)
est store e9
reghdfe ltotal_cwt_three_year_citation promotion_rate4    lno_employee_ey lfirm_capacity   prop_rd prop_manager  ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5, a(inventor_location_employer_title year work_year years_on_the_job) cluster(employer_id2)
est store e10





estadd local fe " ",replace: e1 e2 e3 e4 e5 e6 e7 e8 e9 e10
estadd local yfe "Yes", replace: e1 e2 e3 e4 e5 e6 e7 e8 e9 e10
estadd local wyfe "Yes", replace: e1 e2 e3 e4 e5 e6 e7 e8 e9 e10
estadd local yjfe "Yes", replace: e1 e2 e3 e4 e5 e6 e7 e8 e9 e10
estadd local iofe "Yes", replace: e1 e2 e3 e4 e5 e6 e7 e8 e9 e10
estadd local iolefe2 "Yes", replace: e2 e4 e6 e8 e10
estadd local control "Yes", replace: e1 e2 e3 e4 e5 e6 e7 e8 e9 e10
esttab e1 e2 e3 e4 e5 e6 e7 e8 e9 e10 using "/results/alternative_dvs.tex", replace label se r2 wrap width(\hsize)title("\label{tab:dv} Linear Estimation Predicting Innovation using Internal Promotion and External Hiring Rates") mgroups ( "Num. Applications (log)" "Num. Patents (log)" "Patent Values (log)" "Unadjusted Citations" "Co-authored Adjusted Citations", pattern(1 0 1 0 1 0 1 0 1 0) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) nomtitles keep(promotion_rate4) order(promotion_rate4 ) scalar("fe Fixed Effects:" "yfe Calendar Year" "wyfe Years in the Workforce" "yjfe Years on the Job" "iofe Inventor x Title" "iolefe2 Inventor x Title x Employer x Location" "control Control Variables")
}

	**# Appendix Section F. Different Thresholds
{
foreach num of numlist 0 3 10 20{
	eststo clear
	reghdfe ltotal_wt_three_year_citation promotion_rate4   lno_employee_ey    prop_rd prop_manager lfirm_capacity ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=`num', a(inventor_title year work_year years_on_the_job) cluster(employer_id2)
est store e1
	reghdfe ltotal_wt_three_year_citation promotion_rate4     lno_employee_ey    prop_rd prop_manager lfirm_capacity ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=`num', a(inventor_title  firm_location year work_year years_on_the_job) cluster(employer_id2)
	est store e2
	reghdfe ltotal_wt_three_year_citation promotion_rate4    lno_employee_ey    prop_rd prop_manager lfirm_capacity ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=`num', a(inventor_location_employer_title year work_year years_on_the_job) cluster(employer_id2)
	est store e3

	estadd local fe " ",replace: e1 e2 e3 
	estadd local yfe "Yes", replace: e1 e2 e3 
	estadd local wyfe "Yes", replace: e1 e2 e3
	estadd local yjfe "Yes", replace: e1 e2 e3 
	estadd local iofe "Yes", replace: e1 e2
	estadd local iolefe "Yes", replace: e2 
	estadd local iolefe2 "Yes", replace: e3

	esttab e1 e2 e3 using"/kellogg/proj/eda1891/eda1891-temp/Simeng/Simeng_AJS_RR/Simeng/replication_code_final/final_ajs/results/tables/main_rep_`num'.tex", replace label se r2 wrap width(\hsize)title("\label{tab:main\_rate} Linear Estimation Predicting Innovation using Internal Promotion and External Hiring Rates") mgroups ( "Adjusted Three-Year Forward Citation (log)", pattern(1 0 0 0 0 0) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) nomtitles keep(promotion_rate4 external_hiring_rate4 lno_employee_ey    prop_rd prop_manager ltenure_ey lfirm_capacity) order(promotion_rate4 external_hiring_rate4 lno_employee_ey    prop_rd prop_manager ltenure_ey lfirm_capacity) scalar("fe Fixed Effects:" "yfe Calendar Year" "wyfe Years in the Workforce" "yjfe Years on the Job" "iofe Inventor x Title" "iolefe Employer x Location" "iolefe2 Inventor x Title x Employer x Location" )

}
}

	**# Appendix Section G.  Event Study: Comparing Moves to Firms with Higher vs. Lower Promotion Rates
{
use "all_inventor_linkedin_match9_analysis.dta",clear

bysort inventor_id employer_id2: egen mean_ratio_inventor=mean(promotion_rate4)
bysort inventor_id employer_id2: egen min_employer_year=min(year)
bysort inventor_id employer_id2: egen max_employer_year=max(year)


keep inventor_id rn employer_id2  mean_ratio_inventor min_employer_year max_employer_year
duplicates drop

sort inventor_id rn
by inventor_id: gen order_rn=_n
save "event_test.dta",replace
keep if order_rn<=2&order_rn>=1 
//restrict to first job change
sort inventor_id rn 
by inventor_id: gen mark_to_high=1 if mean_ratio_inventor[_n+1]>=mean_ratio_inventor+0.1
by inventor_id: gen mark_to_low=1 if mean_ratio_inventor[_n+1]<=mean_ratio_inventor-0.1
gen first_employer_id2=employer_id2 if order_rn==1
destring first_employer_id2, replace
sort inventor_id first_employer_id2
by inventor_id: replace first_employer_id2=first_employer_id2[1]
gen first_employer_id2_max_year=max_employer_year if order_rn==1
sort inventor_id first_employer_id2_max_year
by inventor_id: replace first_employer_id2_max_year=first_employer_id2_max_year[1]
egen treat_group=group(first_employer_id2 first_employer_id2_max_year)
bysort treat_group: egen count_treat=total(mark_to_high)
bysort treat_group: egen count_control=total(mark_to_low)
//drop those treat_group in which there is no control or treat inventors
gen drop=1 if count_treat==0|count_control==0
save "event_test_rn2.dta",replace
drop if drop==1
sort inventor_id mark_to_high
by inventor_id: replace mark_to_high=mark_to_high[1]
sort inventor_id mark_to_low

by inventor_id: replace mark_to_low=mark_to_low[1]
gen treat=1 if mark_to_high==1
replace treat=0 if mark_to_low==1
save "event_test_rn23.dta",replace


keep first_employer_id2_max_year inventor_id rn treat treat_group
duplicates drop
merge 1:m inventor_id rn using "all_inventor_linkedin_match9_analysis.dta"
keep if _merge==3
drop _merge
save "event_test_rn24.dta",replace



gen years_since=year-first_employer_id2_max_year
sum years_since
gen years_since2=years_since+abs(r(min))
labmask years_since2,value(years_since)





reghdfe ltotal_wt_three_year_citation ib24.years_since2##i.treat  lno_employee_ey  lfirm_capacity  prop_rd prop_manager ltenure_ey if year>=2000&year<=2025& first_employer_id2_max_year >2004&first_employer_id2_max_year<2021&abs(years_since)<=5, a(inventor_title wk_state year work_year years_on_the_job treat_group) cluster(employer_id2)
set scheme cblind1


coefplot, keep(*.years_since2#1.treat) vertical base omit xlabel(1 "-5" 2 "-4" 3 "-3" 4 "-2" 5 "-1" 6 "0" 7 "1" 8 "2" 9 "3" 10 "4" 11 "5" ) xtitle(Years Since Switching Employers) ytitle(Estimated Adjusted Three-Year Forward Citation (log),size(med)) mcolor(red) ciopts(color(red)) ylabel(,nogrid) yline(0)  cirecast(rcap) 

graph export "/results/event_test_citation.eps", as(eps) name("Graph") preview(off) replace

reghdfe lpatent_count ib24.years_since2##i.treat  lno_employee_ey  lfirm_capacity  prop_rd prop_manager ltenure_ey if year>=2000&year<=2025& first_employer_id2_max_year >2004&first_employer_id2_max_year<2021&abs(years_since)<=5, a(inventor_title wk_state year work_year years_on_the_job treat_group) cluster(employer_id2)

coefplot, keep(*.years_since2#1.treat) vertical base omit xlabel(1 "-5" 2 "-4" 3 "-3" 4 "-2" 5 "-1" 6 "0" 7 "1" 8 "2" 9 "3" 10 "4" 11 "5" ) xtitle(Years Since Switching Employers) ytitle(Estimated Number of Patents (log),size(med)) mcolor(red) ciopts(color(red)) ylabel(,nogrid) yline(0)  cirecast(rcap) 

graph export "/results/event_test_count.eps", as(eps) name("Graph") preview(off) replace



}



	**# Appendix Section H. Heterogeneity by Productivity and Gender
//Table H.1
{

eststo clear

reghdfe ltotal_wt_three_year_citation promotion_rate4   lno_employee_ey    prop_rd prop_manager lfirm_capacity ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5&top_inventor==1, a(inventor_title year work_year years_on_the_job) cluster(employer_id2)
est store e1
reghdfe ltotal_wt_three_year_citation promotion_rate4     lno_employee_ey    prop_rd prop_manager lfirm_capacity ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5&top_inventor==1, a(inventor_title firm_location year work_year years_on_the_job) cluster(employer_id2)
est store e2
reghdfe ltotal_wt_three_year_citation promotion_rate4    lno_employee_ey    prop_rd prop_manager lfirm_capacity ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5&top_inventor==1, a(inventor_location_employer_title year work_year years_on_the_job) cluster(employer_id2)
est store e3

reghdfe ltotal_wt_three_year_citation promotion_rate4   lno_employee_ey    prop_rd prop_manager lfirm_capacity ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5&top_inventor!=1, a(inventor_title year work_year years_on_the_job) cluster(employer_id2)
est store e4
reghdfe ltotal_wt_three_year_citation promotion_rate4     lno_employee_ey    prop_rd prop_manager lfirm_capacity ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5&top_inventor!=1, a(inventor_title firm_location year work_year years_on_the_job) cluster(employer_id2)
est store e5
reghdfe ltotal_wt_three_year_citation promotion_rate4    lno_employee_ey    prop_rd prop_manager lfirm_capacity ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5&top_inventor!=1, a(inventor_location_employer_title year work_year years_on_the_job) cluster(employer_id2)
est store e6

estadd local fe " ",replace: e1 e2 e3 e4 e5 e6
estadd local yfe "Yes", replace: e1 e2 e3 e4 e5 e6
estadd local wyfe "Yes", replace: e1 e2 e3 e4 e5 e6
estadd local yjfe "Yes", replace: e1 e2 e3 e4 e5 e6
estadd local iofe "Yes", replace: e1 e2 e4 e5
estadd local iolefe "Yes", replace: e2 e4
estadd local iolefe2 "Yes", replace: e3 e6
estadd local control "Yes", replace: e1 e2 e3 e4 e5 e6
esttab e1 e2 e3 e4 e5 e6 using"/results/main_rep_top_nontop.tex", replace label se r2 wrap width(\hsize)title("\label{tab:top} Linear Estimation Predicting Innovation using Internal Promotion and External Hiring Rates") mgroups ( "Top Inventor" "Non-Top Inventor", pattern(1 0 0 1 0 0) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) nomtitles keep(promotion_rate4) order(promotion_rate4) scalar("fe Fixed Effects:" "yfe Calendar Year" "wyfe Years in the Workforce" "yjfe Years on the Job" "iofe Inventor x Occupation" "iolefe Employer x Location" "iolefe2 Inventor x Occupation x Employer x Location"  "control Control Variables" )
}
//Table H.2
{
eststo clear

reghdfe ltotal_wt_three_year_citation promotion_rate4   lno_employee_ey    prop_rd prop_manager lfirm_capacity ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5&gender_code==1, a(inventor_title year work_year years_on_the_job) cluster(employer_id2)
est store e1
reghdfe ltotal_wt_three_year_citation promotion_rate4     lno_employee_ey    prop_rd prop_manager lfirm_capacity ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5&gender_code==1, a(inventor_title firm_location year work_year years_on_the_job) cluster(employer_id2)
est store e2
reghdfe ltotal_wt_three_year_citation promotion_rate4    lno_employee_ey    prop_rd prop_manager lfirm_capacity ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5&gender_code==1, a(inventor_location_employer_title year work_year years_on_the_job) cluster(employer_id2)
est store e3

reghdfe ltotal_wt_three_year_citation promotion_rate4   lno_employee_ey    prop_rd prop_manager lfirm_capacity ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5&gender_code==2, a(inventor_title year work_year years_on_the_job) cluster(employer_id2)
est store e4
reghdfe ltotal_wt_three_year_citation promotion_rate4     lno_employee_ey    prop_rd prop_manager lfirm_capacity ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5&gender_code==2, a(inventor_title firm_location year work_year years_on_the_job) cluster(employer_id2)
est store e5
reghdfe ltotal_wt_three_year_citation promotion_rate4    lno_employee_ey    prop_rd prop_manager lfirm_capacity ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5&gender_code==2, a(inventor_location_employer_title year work_year years_on_the_job) cluster(employer_id2)
est store e6

estadd local fe " ",replace: e1 e2 e3 e4 e5 e6
estadd local yfe "Yes", replace: e1 e2 e3 e4 e5 e6
estadd local wyfe "Yes", replace: e1 e2 e3 e4 e5 e6
estadd local yjfe "Yes", replace: e1 e2 e3 e4 e5 e6
estadd local iofe "Yes", replace: e1 e2 e4 e5
estadd local iolefe "Yes", replace: e2 e4
estadd local iolefe2 "Yes", replace: e3 e6
estadd local control "Yes", replace: e1 e2 e3 e4 e5 e6
esttab e1 e2 e3 e4 e5 e6 using"/results/main_rep_gender.tex", replace label se r2 wrap width(\hsize)title("\label{tab:gender} Linear Estimation Predicting Innovation using Internal Promotion and External Hiring Rates") mgroups ( "Woman" "Man", pattern(1 0 0 1 0 0) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) nomtitles keep(promotion_rate4) order(promotion_rate4) scalar("fe Fixed Effects:" "yfe Calendar Year" "wyfe Years in the Workforce" "yjfe Years on the Job" "iofe Inventor x Occupation" "iolefe Employer x Location" "iolefe2 Inventor x Occupation x Employer x Location"  "control Control Variables" )

}


**# Appendix Section I. Comparison to Inventors in the Most Senior Position

{
bysort employer_id2 year: egen max_seniority=max(adj_seniority)
gen possibility_dummy=adj_seniority==max_seniority
replace possibility_dummy=. if missing(adj_seniority)

eststo clear

reghdfe ltotal_wt_three_year_citation c.promotion_rate4##ib0.possibility_dummy   lno_employee_ey    prop_rd prop_manager lfirm_capacity ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5, a(inventor_title year work_year years_on_the_job) cluster(employer_id2)


cap drop tp*
gen tp1=_b[promotion_rate4] if _n==1
gen tp1_se=_se[promotion_rate4]
gen tp_year=0 if _n==1
foreach num of numlist 1 {
		replace tp1=_b[`num'.possibility_dummy#promotion_rate4]+_b[promotion_rate4] if _n==`num'+1
		replace tp1_se=sqrt(((_se[`num'.possibility_dummy#promotion_rate4])^2)+((_se[promotion_rate4])^2)) if _n==`num'+1
		replace tp_year=`num' if _n==`num'+1
}
gen tp1_se1=tp1+1.645*tp1_se
gen tp1_se2=tp1-1.645*tp1_se

set scheme cblind1
twoway scatter  tp1 tp_year,mcolor(red)|| rcap tp1_se1 tp1_se2 tp_year, lcolor(red) mcolor(red) yline(0) ytitle(Estimated Coefficient Predicting Adj. Three-Year Forward Citation (log),size(small)) xtitle(Seniority Position,size(med)) xlabel( 0 "Not Highest-Seniority" 1 "Highest-Seniority", nogrid) ylabel(,nogrid) legend(off)
graph export "/results/seniority_iofe.png", as(png) name("Graph") replace



reghdfe ltotal_wt_three_year_citation c.promotion_rate4##c.possibility_dummy        lno_employee_ey    prop_rd prop_manager lfirm_capacity ltenure_ey if year>=2000&year<=2025&total_inventor_year3>=5, a(inventor_title firm_location year work_year years_on_the_job) cluster(employer_id2)
est store e2

cap drop tp*
gen tp1=_b[promotion_rate4] if _n==1
gen tp1_se=_se[promotion_rate4]
gen tp_year=0 if _n==1
foreach num of numlist 1 {
		replace tp1=_b[c.possibility_dummy#promotion_rate4]+_b[promotion_rate4] if _n==`num'+1
		replace tp1_se=sqrt(((_se[c.possibility_dummy#promotion_rate4])^2)+((_se[promotion_rate4])^2)) if _n==`num'+1
		replace tp_year=`num' if _n==`num'+1
}
gen tp1_se1=tp1+1.645*tp1_se
gen tp1_se2=tp1-1.645*tp1_se

set scheme cblind1
twoway scatter  tp1 tp_year,mcolor(red)|| rcap tp1_se1 tp1_se2 tp_year, lcolor(red) mcolor(red) yline(0) ytitle(Estimated Coefficient Predicting Adj. Three-Year Forward Citation (log),size(small)) xtitle(Seniority Position,size(med)) xlabel( 0 "Not Highest-Seniority" 1 "Highest-Seniority", nogrid) ylabel(,nogrid) legend(off)
graph export "/results/seniority_ioflfe.png", as(png) name("Graph") replace

}

	**# Appendix Section J. Performance of Internally Promoted versus Externally Hired
//Figure J.1
{
gen occupation_year=year if change_occupation2==1
sort id2 employer_id2 change_occupation2 occupation_year order
by id2 employer_id2 change_occupation2: gen no_titlechange=_n if change_occupation2==1
bysort id2 employer_id2: egen min_occupation_year=min(occupation_year)
gen first_occupation_order=order if change_occupation2==1& year==min_occupation_year
sort id2 employer_id2  first_occupation_order
by id2 employer_id2 : replace first_occupation_order=first_occupation_order[1] if missing(first_occupation_order)

bysort id2 employer_id2: gen second_occupation_order=order if change_occupation2==1& no_titlechange==2
sort id2 employer_id2  second_occupation_order
by id2 employer_id2 : replace second_occupation_order=second_occupation_order[1] if missing(second_occupation_order)

bysort id2 employer_id2: gen year_after_1occupation=year-min_occupation_year if order<second_occupation_order
sum year_after_1occupation
gen year_after_1occupation3=year_after_1occupation+abs(r(min))
labmask year_after_1occupation3, value(year_after_1occupation)

egen inventor_employer_location=group(inventor_id employer_id2 wk_state)
set scheme cblind1
reghdfe ltotal_wt_three_year_citation ib24.year_after_1occupation3  lno_employee_ey   lfirm_capacity  prop_rd  prop_manager ltenure_ey if year>=2000&year<=2025&order<second_occupation_order &year_after_1occupation<=5 & year_after_1occupation>=-4, a(inventor_employer_location year work_year) cluster(employer_id2)
coefplot, keep(*.year_after_1occupation3) baselevels vertical xtitle(Years Before/After First Internal Occupation Change,size(med)) ytitle(Estimated Coefficient Predicting Adj. Three-Year Forward Citation (log),size(small)) mcolor(red) ciopts(color(red)) ylabel(,nogrid) yline(0)  cirecast(rcap) 
graph export "/results/productivity_occupation.png", as(png) name("Graph") replace


gen transition_year=year if transition==1
sort id2 employer_id2 transition_year 
by id2 employer_id2: gen transition_year2=transition_year[1]
gen year_after_transition=year-transition_year2+1

sort id2 transition transition_year order 
by id2 transition: gen no_transition=_n if transition==1
bysort id2 employer_id2: egen no_transition2=mean(no_transition)


replace year_after_transition=0 if missing(year_after_transition)
bysort id2: egen first_order=min(order) if no_transition2==1
sort id2 first_order
by id2: replace first_order=first_order[1]
replace no_transition2=0 if order<first_order & transition!=1
replace transition=. if missing(no_transition2)
replace year_after_transition=. if missing(no_transition2)
replace year_after_transition=order-first_order+1 if no_transition2==0


bysort id2: egen min_transition_year=min(transition_year)
bysort id2: egen second_order=min(order) if no_transition2==2
bysort id2: gen year_after_1transition=year-min_transition_year if order<second_order
sum year_after_1transition
gen year_after_1transition3=year_after_1transition+abs(r(min))
labmask year_after_1transition3, value(year_after_1transition)


set scheme cblind1
reghdfe ltotal_wt_three_year_citation ib24.year_after_1transition3  lno_employee_ey   lfirm_capacity  prop_rd  prop_manager ltenure_ey if year>=2000&year<=2025&order<second_order &year_after_1transition<=5 & year_after_1transition>=-4, a(inventor_employer_location year work_year) cluster(employer_id2)
coefplot, keep(*.year_after_1transition3) baselevels vertical xtitle(Years Before/After First External Labor Market Change,size(med)) ytitle(Estimated Coefficient Predicting Adj. Three-Year Forward Citation (log),size(small)) mcolor(red) ciopts(color(red)) ylabel(,nogrid) yline(0)  cirecast(rcap) 
graph export "/results/productivity_turnover.png", as(png) name("Graph") replace
}
//Figure J.2
{
egen employer_title=group(employer_id2 title2_id)

gen internal_promotion=1 if mark32==1
replace internal_promotion=0 if missing(internal_promotion)

gen external_hire=1 if mark9==1
replace external_hire=0 if missing(external_hire)

bysort id2 employer_id2 title2_id: egen internal_promotion2=max(internal_promotion)
bysort id2 employer_id2 title2_id: egen external_hire2=max(external_hire)
reghdfe ltotal_wt_three_year_citation i.internal_promotion2##ib0.years_on_the_job  lno_employee_ey  lfirm_capacity  prop_rd prop_manager ltenure_ey if year>=2000&year<=2025&(internal_promotion2==1|external_hire2==1)&years_on_the_job>=0&years_on_the_job<=5&vacancy_ey>=3, a(employer_title  year work_year) cluster(employer_id2)


cap drop tp*
gen tp1=_b[1.internal_promotion2] if _n==1

gen tp1_se=_se[1.internal_promotion2]
gen tp_year=0 if _n==1
foreach num of numlist 1(1)5 {
		replace tp1=_b[1.internal_promotion2#`num'.years_on_the_job]+_b[1.internal_promotion2] if _n==`num'+1
		replace tp1_se=sqrt(((_se[1.internal_promotion2#`num'.years_on_the_job])^2)+((_se[1.internal_promotion2])^2)) if _n==`num'+1
		replace tp_year=`num' if _n==`num'+1
}
gen tp1_se1=tp1+1.645*tp1_se
gen tp1_se2=tp1-1.645*tp1_se


twoway rcap tp1_se1 tp1_se2 tp_year, lcolor(red)|| connected tp1 tp_year, mcolor(red) lcolor(red) yline(0) ytitle(Estimated Difference in Adjusted Three-Year Citation (log),size(small)) xtitle(Years on the Job,size(med)) xlabel(, nogrid) ylabel(,nogrid) legend(off)

graph export "/results/internal_external_gap.png", as(png) name("Graph") replace




reghdfe ltotal_wt_three_year_citation i.internal_promotion2##ib0.years_on_the_job  lno_employee_ey  lfirm_capacity  prop_rd prop_manager ltenure_ey if year>=2000&year<=2025&(internal_promotion2==1|external_hire2==1)&years_on_the_job>=0&years_on_the_job<=5&vacancy_ey>=3, a(title2_id  year work_year) cluster(employer_id2)


cap drop tp*
gen tp1=_b[1.internal_promotion2] if _n==1

gen tp1_se=_se[1.internal_promotion2]
gen tp_year=0 if _n==1
foreach num of numlist 1(1)5 {
		replace tp1=_b[1.internal_promotion2#`num'.years_on_the_job]+_b[1.internal_promotion2] if _n==`num'+1
		replace tp1_se=sqrt(((_se[1.internal_promotion2#`num'.years_on_the_job])^2)+((_se[1.internal_promotion2])^2)) if _n==`num'+1
		replace tp_year=`num' if _n==`num'+1
}
gen tp1_se1=tp1+1.645*tp1_se
gen tp1_se2=tp1-1.645*tp1_se


twoway rcap tp1_se1 tp1_se2 tp_year, lcolor(red)|| connected tp1 tp_year, mcolor(red) lcolor(red) yline(0) ytitle(Estimated Difference in Adjusted Three-Year Citation (log),size(small)) xtitle(Years on the Job,size(med)) xlabel(, nogrid) ylabel(,nogrid) legend(off)

graph export "/results/internal_external_gap_ofe.png", as(png) name("Graph") replace

}
//Table J.1
{

label var internal_promotion2 "Internally Promoted Inventor"
gen interaction=years_on_the_job*internal_promotion2
label var interaction "Internally Promoted Inventor x Years on the Job"


eststo clear

reghdfe ltotal_wt_three_year_citation internal_promotion2  lno_employee_ey lfirm_capacity   prop_rd prop_manager ltenure_ey if year>=2000&year<=2025&(internal_promotion2==1|external_hire2==1)&years_on_the_job>=0&years_on_the_job<=5&vacancy_ey>=3, a(year work_year years_on_the_job) cluster(employer_id2)
est store e1
reghdfe ltotal_wt_three_year_citation internal_promotion2  lno_employee_ey  lfirm_capacity  prop_rd prop_manager ltenure_ey if year>=2000&year<=2025&(internal_promotion2==1|external_hire2==1)&years_on_the_job>=0&years_on_the_job<=5&vacancy_ey>=3, a(title2_id  year work_year years_on_the_job) cluster(employer_id2)
est store e2
reghdfe ltotal_wt_three_year_citation internal_promotion2  lno_employee_ey  lfirm_capacity  prop_rd prop_manager ltenure_ey if year>=2000&year<=2025&(internal_promotion2==1|external_hire2==1)&years_on_the_job>=0&years_on_the_job<=5&vacancy_ey>=3, a(employer_title  year work_year years_on_the_job) cluster(employer_id2)
est store e3
reghdfe ltotal_wt_three_year_citation internal_promotion2  interaction lno_employee_ey lfirm_capacity   prop_rd prop_manager ltenure_ey if year>=2000&year<=2025&(internal_promotion2==1|external_hire2==1)&years_on_the_job>=0&years_on_the_job<=5&vacancy_ey>=3, a(year work_year years_on_the_job) cluster(employer_id2)
est store e4
reghdfe ltotal_wt_three_year_citation internal_promotion2 interaction lno_employee_ey lfirm_capacity   prop_rd prop_manager ltenure_ey if year>=2000&year<=2025&(internal_promotion2==1|external_hire2==1)&years_on_the_job>=0&years_on_the_job<=5&vacancy_ey>=3, a(title2_id  year work_year years_on_the_job) cluster(employer_id2)
est store e5
reghdfe ltotal_wt_three_year_citation internal_promotion2 interaction lno_employee_ey  lfirm_capacity  prop_rd prop_manager ltenure_ey if year>=2000&year<=2025&(internal_promotion2==1|external_hire2==1)&years_on_the_job>=0&years_on_the_job<=5&vacancy_ey>=3, a(employer_title  year work_year years_on_the_job) cluster(employer_id2)
est store e6


estadd local fe " ",replace: e1 e2 e3 e4 e5 e6
estadd local yfe "Yes", replace: e1 e2 e3 e4 e5 e6
estadd local wyfe "Yes", replace: e1 e2 e3 e4 e5 e6
estadd local yjfe "Yes", replace: e1 e2 e3 e4 e5 e6
estadd local ofe "Yes", replace: e2 e5 
estadd local eofe "Yes", replace:  e3 e6
estadd local control "Yes", replace: e1 e2 e3 e4 e5 e6

esttab e1 e2 e3 e4 e5 e6 using"/results/performance_gap.tex", replace label se r2 wrap width(\hsize)title("\label{tab:performance} Linear Estimation Predicting Innovation: Performance Difference Between Internally Promoted and Externally Hired Inventors") mgroups ("Adjusted Three-Year Forward Citation (log)", pattern(1 0 0 0 0 0) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) nomtitles keep(internal_promotion2  interaction) order(internal_promotion2 interaction) scalar("fe Fixed Effects:" "yfe Calendar Year" "wyfe Years in the Workforce" "yjfe Years on the Job" "ofe Title" "eofe Employer x Title" "control Control Variables" )
}
